/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class BlowingModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
    }

    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        Player player = context.getPlayerAttacker();
        LivingEntity target = context.getLivingTarget();
        if (player == null || target == null) {
            return knockback;
        }
        if (target instanceof Player) {
            return knockback;
        }
        Level world = target.m_20193_();
        if (!world.f_46443_ && RANDOM.nextFloat() <= 0.2f * (float)modifier.getLevel()) {
            ItemStack stack2drop = target.m_21205_();
            if (stack2drop.m_41619_()) {
                stack2drop = target.m_21206_();
                target.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            } else if (!stack2drop.m_41619_()) {
                target.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            } else {
                return knockback;
            }
            ItemEntity item = new ItemEntity(world, target.m_20185_(), target.m_20186_(), target.m_20189_(), stack2drop);
            world.m_7967_((Entity)item);
        }
        return knockback;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null && attacker != null && projectile instanceof AbstractArrow && !attacker.m_9236_().f_46443_ && RANDOM.nextFloat() <= 0.2f * (float)modifier.getLevel()) {
            ItemStack stack2drop = target.m_21205_();
            if (stack2drop.m_41619_()) {
                stack2drop = target.m_21206_();
                target.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            } else if (!stack2drop.m_41619_()) {
                target.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            } else {
                return false;
            }
            ItemEntity item = new ItemEntity(attacker.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), stack2drop);
            attacker.m_9236_().m_7967_((Entity)item);
        }
        return false;
    }
}

